package com.ejie.aa17a.service.iface;

import java.util.List;

import com.ejie.aa17a.model.Aa17aEstacion;
import com.ejie.aa17a.model.geojson.Aa17aGeojson;

/**
 * Aa17aEstacionService generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

public interface Aa17aEstacionService {

	/**
	 * Finds a single row in the Aa17aEstacion table.
	 * 
	 * @param aa17aEstacion
	 *            Aa17aEstacion
	 * @return Aa17aEstacion
	 */
	Aa17aEstacion find(Aa17aEstacion aa17aEstacion);

	/**
	 * Finds a List of rows in the Aa17aEstacion table.
	 * 
	 * @param aa17aEstacion
	 *            Aa17aEstacion
	 * @return List
	 */
	List<Aa17aEstacion> findAll(Aa17aEstacion aa17aEstacion);

	/**
	 * Devuelve un bean geojson con la lista de estaciones y sus coordenadas
	 * para la carga del mapa de la portada web
	 * 
	 * @param aa17aEstacion
	 *            Aa17aEstacion
	 * @return Aa17aGeojson
	 */
	Aa17aGeojson getGeojsonMapa(Aa17aEstacion aa17aEstacion);

	/**
	 * Devuelve la lista de estaciones con la información de la banda
	 * correspondiente
	 * 
	 * @param aa17aEstacion
	 *            Aa17aEstacion
	 * @return List<Aa17aEstacion>
	 */
	List<Aa17aEstacion> getListEstacionesConBanda(Aa17aEstacion aa17aEstacion);

	/**
	 * Devuelve los datos de una estacion con la información de la banda
	 * correspondiente
	 * 
	 * @param aa17aEstacion
	 *            Aa17aEstacion
	 * @return Aa17aEstacion
	 */
	Aa17aEstacion getEstacionConBanda(Aa17aEstacion aa17aEstacion);

}
